/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.metalbarrels;

import com.google.common.collect.Sets;
import com.tfar.metalbarrels.block.CrystalBarrelBlock;
import com.tfar.metalbarrels.block.MetalBarrelBlock;
import com.tfar.metalbarrels.container.MetalBarrelContainer;
import com.tfar.metalbarrels.item.BarrelUpgradeItem;
import com.tfar.metalbarrels.item.UpgradeInfo;
import com.tfar.metalbarrels.network.PacketHandler;
import com.tfar.metalbarrels.screens.MetalBarrelScreen;
import com.tfar.metalbarrels.tile.MetalBarrelBlockEntity;
import com.tfar.metalbarrels.util.MetalBarrelBlockEntityType;
import com.tfar.metalbarrels.util.ModTags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="metalbarrels")
public class MetalBarrels {
    public static final String MODID = "metalbarrels";
    public static final Logger logger = LogManager.getLogger();
    public static final CreativeModeTab tab = new CreativeModeTab("metalbarrels"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ObjectHolders.DIAMOND_BARREL);
        }
    };

    public MetalBarrels() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        PacketHandler.register();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MenuScreens.m_96206_(ObjectHolders.COPPER_CONTAINER, MetalBarrelScreen::copper);
        MenuScreens.m_96206_(ObjectHolders.IRON_CONTAINER, MetalBarrelScreen::iron);
        MenuScreens.m_96206_(ObjectHolders.SILVER_CONTAINER, MetalBarrelScreen::silver);
        MenuScreens.m_96206_(ObjectHolders.GOLD_CONTAINER, MetalBarrelScreen::gold);
        MenuScreens.m_96206_(ObjectHolders.DIAMOND_CONTAINER, MetalBarrelScreen::diamond);
        MenuScreens.m_96206_(ObjectHolders.NETHERITE_CONTAINER, MetalBarrelScreen::netherite);
    }

    @ObjectHolder(value="metalbarrels")
    public static class ObjectHolders {
        public static final Block COPPER_BARREL = null;
        public static final MenuType<MetalBarrelContainer> COPPER_CONTAINER = null;
        public static final BlockEntityType<MetalBarrelBlockEntity> COPPER_TILE = null;
        public static final Block IRON_BARREL = null;
        public static final MenuType<MetalBarrelContainer> IRON_CONTAINER = null;
        public static final BlockEntityType<MetalBarrelBlockEntity> IRON_TILE = null;
        public static final Block GOLD_BARREL = null;
        public static final MenuType<MetalBarrelContainer> GOLD_CONTAINER = null;
        public static final BlockEntityType<MetalBarrelBlockEntity> GOLD_TILE = null;
        public static final Block DIAMOND_BARREL = null;
        public static final MenuType<MetalBarrelContainer> DIAMOND_CONTAINER = null;
        public static final BlockEntityType<MetalBarrelBlockEntity> DIAMOND_TILE = null;
        public static final Block NETHERITE_BARREL = null;
        public static final MenuType<MetalBarrelContainer> NETHERITE_CONTAINER = null;
        public static final BlockEntityType<MetalBarrelBlockEntity> NETHERITE_TILE = null;
        public static final Block OBSIDIAN_BARREL = null;
        public static final Block SILVER_BARREL = null;
        public static final MenuType<MetalBarrelContainer> SILVER_CONTAINER = null;
        public static final BlockEntityType<MetalBarrelBlockEntity> SILVER_TILE = null;
        public static final Block CRYSTAL_BARREL = null;
        public static final BlockEntityType<MetalBarrelBlockEntity> CRYSTAL_TILE = null;
    }

    @ObjectHolder(value="ironchest")
    public static class IronChestObjectHolders {
        public static final Block COPPER_CHEST = null;
        public static final Block IRON_CHEST = null;
        public static final Block SILVER_CHEST = null;
        public static final Block GOLD_CHEST = null;
        public static final Block DIAMOND_CHEST = null;
        public static final Block CRYSTAL_CHEST = null;
        public static final Block OBSIDIAN_CHEST = null;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        private static final Set<Block> MOD_BLOCKS = new HashSet<Block>();

        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            BlockBehaviour.Properties metal = BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(1.0f, 6.0f).m_60918_(SoundType.f_56743_);
            BlockBehaviour.Properties obsidian = BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(2.5f, 6000.0f);
            RegistryEvents.registerBlock((Block)new MetalBarrelBlock(metal, MetalBarrelBlockEntityType.copper()), "copper_barrel", (IForgeRegistry<Block>)blockRegistryEvent.getRegistry());
            RegistryEvents.registerBlock((Block)new MetalBarrelBlock(metal, MetalBarrelBlockEntityType.iron()), "iron_barrel", (IForgeRegistry<Block>)blockRegistryEvent.getRegistry());
            RegistryEvents.registerBlock((Block)new MetalBarrelBlock(metal, MetalBarrelBlockEntityType.silver()), "silver_barrel", (IForgeRegistry<Block>)blockRegistryEvent.getRegistry());
            RegistryEvents.registerBlock((Block)new MetalBarrelBlock(metal, MetalBarrelBlockEntityType.gold()), "gold_barrel", (IForgeRegistry<Block>)blockRegistryEvent.getRegistry());
            RegistryEvents.registerBlock((Block)new MetalBarrelBlock(metal, MetalBarrelBlockEntityType.diamond()), "diamond_barrel", (IForgeRegistry<Block>)blockRegistryEvent.getRegistry());
            RegistryEvents.registerBlock((Block)new MetalBarrelBlock(obsidian, MetalBarrelBlockEntityType.diamond()), "obsidian_barrel", (IForgeRegistry<Block>)blockRegistryEvent.getRegistry());
            RegistryEvents.registerBlock((Block)new MetalBarrelBlock(obsidian, MetalBarrelBlockEntityType.netherite()), "netherite_barrel", (IForgeRegistry<Block>)blockRegistryEvent.getRegistry());
            RegistryEvents.registerBlock((Block)new CrystalBarrelBlock(metal.m_60955_(), MetalBarrelBlockEntityType.diamond()), "crystal_barrel", (IForgeRegistry<Block>)blockRegistryEvent.getRegistry());
        }

        private static void registerBlock(Block block, String name, IForgeRegistry<Block> registry) {
            registry.register((IForgeRegistryEntry)((Block)block.setRegistryName(name)));
            MOD_BLOCKS.add(block);
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> itemRegistryEvent) {
            IForgeRegistry registry = itemRegistryEvent.getRegistry();
            for (Block block : MOD_BLOCKS) {
                Item.Properties properties = new Item.Properties().m_41491_(tab);
                if (block == ObjectHolders.NETHERITE_BARREL) {
                    properties.m_41486_();
                }
                BlockItem item = new BlockItem(block, properties);
                RegistryEvents.registerItem((Item)item, block.getRegistryName().toString(), (IForgeRegistry<Item>)registry);
            }
            Item.Properties properties = new Item.Properties().m_41491_(tab);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.WOODEN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.COPPER_BARREL))).add((TagKey<Block>)Tags.Blocks.CHESTS_WOODEN, IronChestObjectHolders.COPPER_CHEST, "ironchest")), "wood_to_copper", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.WOODEN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.IRON_BARREL))).add((TagKey<Block>)Tags.Blocks.CHESTS_WOODEN, IronChestObjectHolders.IRON_CHEST, "ironchest")), "wood_to_iron", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.WOODEN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.SILVER_BARREL))).add((TagKey<Block>)Tags.Blocks.CHESTS_WOODEN, IronChestObjectHolders.SILVER_CHEST, "ironchest")), "wood_to_silver", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.WOODEN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.GOLD_BARREL))).add((TagKey<Block>)Tags.Blocks.CHESTS_WOODEN, IronChestObjectHolders.GOLD_CHEST, "ironchest")), "wood_to_gold", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.WOODEN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.DIAMOND_BARREL))).add((TagKey<Block>)Tags.Blocks.CHESTS_WOODEN, IronChestObjectHolders.DIAMOND_CHEST, "ironchest")), "wood_to_diamond", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.WOODEN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.OBSIDIAN_BARREL))).add((TagKey<Block>)Tags.Blocks.CHESTS_WOODEN, IronChestObjectHolders.OBSIDIAN_CHEST, "ironchest")), "wood_to_obsidian", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.WOODEN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.NETHERITE_BARREL)))), "wood_to_netherite", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.COPPER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.IRON_BARREL))).add(ModTags.Blocks.COPPER_CHESTS, IronChestObjectHolders.IRON_CHEST, "ironchest")), "copper_to_iron", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.COPPER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.SILVER_BARREL))).add(ModTags.Blocks.COPPER_CHESTS, IronChestObjectHolders.SILVER_CHEST, "ironchest")), "copper_to_silver", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.COPPER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.GOLD_BARREL))).add(ModTags.Blocks.COPPER_CHESTS, IronChestObjectHolders.GOLD_CHEST, "ironchest")), "copper_to_gold", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.COPPER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.DIAMOND_BARREL))).add(ModTags.Blocks.COPPER_CHESTS, IronChestObjectHolders.DIAMOND_CHEST, "ironchest")), "copper_to_diamond", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.COPPER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.OBSIDIAN_BARREL))).add(ModTags.Blocks.COPPER_CHESTS, IronChestObjectHolders.OBSIDIAN_CHEST, "ironchest")), "copper_to_obsidian", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.IRON_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.SILVER_BARREL))).add(ModTags.Blocks.IRON_CHESTS, IronChestObjectHolders.SILVER_CHEST, "ironchest")), "iron_to_silver", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.IRON_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.GOLD_BARREL))).add(ModTags.Blocks.IRON_CHESTS, IronChestObjectHolders.GOLD_CHEST, "ironchest")), "iron_to_gold", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.IRON_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.DIAMOND_BARREL))).add(ModTags.Blocks.IRON_CHESTS, IronChestObjectHolders.DIAMOND_CHEST, "ironchest")), "iron_to_diamond", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.IRON_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.OBSIDIAN_BARREL))).add(ModTags.Blocks.IRON_CHESTS, IronChestObjectHolders.OBSIDIAN_CHEST, "ironchest")), "iron_to_obsidian", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.SILVER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.GOLD_BARREL))).add(ModTags.Blocks.SILVER_CHESTS, IronChestObjectHolders.GOLD_CHEST, "ironchest")), "silver_to_gold", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.SILVER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.DIAMOND_BARREL))).add(ModTags.Blocks.SILVER_CHESTS, IronChestObjectHolders.DIAMOND_CHEST, "ironchest")), "silver_to_diamond", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.SILVER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.OBSIDIAN_BARREL))).add(ModTags.Blocks.SILVER_CHESTS, IronChestObjectHolders.OBSIDIAN_CHEST, "ironchest")), "silver_to_obsidian", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.GOLD_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.DIAMOND_BARREL))).add(ModTags.Blocks.GOLD_CHESTS, IronChestObjectHolders.DIAMOND_CHEST, "ironchest")), "gold_to_diamond", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.GOLD_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.OBSIDIAN_BARREL))).add(ModTags.Blocks.GOLD_CHESTS, IronChestObjectHolders.OBSIDIAN_CHEST, "ironchest")), "gold_to_obsidian", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.DIAMOND_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.OBSIDIAN_BARREL))).add(ModTags.Blocks.DIAMOND_CHESTS, IronChestObjectHolders.OBSIDIAN_CHEST, "ironchest")), "diamond_to_obsidian", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.WOODEN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.CRYSTAL_BARREL))).add((TagKey<Block>)Tags.Blocks.CHESTS_WOODEN, IronChestObjectHolders.CRYSTAL_CHEST, "ironchest")), "wood_to_crystal", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.COPPER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.CRYSTAL_BARREL))).add(ModTags.Blocks.COPPER_CHESTS, IronChestObjectHolders.CRYSTAL_CHEST, "ironchest")), "copper_to_crystal", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.IRON_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.CRYSTAL_BARREL))).add(ModTags.Blocks.IRON_CHESTS, IronChestObjectHolders.CRYSTAL_CHEST, "ironchest")), "iron_to_crystal", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.SILVER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.CRYSTAL_BARREL))).add(ModTags.Blocks.SILVER_CHESTS, IronChestObjectHolders.CRYSTAL_CHEST, "ironchest")), "silver_to_crystal", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.GOLD_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.CRYSTAL_BARREL))).add(ModTags.Blocks.GOLD_CHESTS, IronChestObjectHolders.CRYSTAL_CHEST, "ironchest")), "gold_to_crystal", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.DIAMOND_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.CRYSTAL_BARREL))).add(ModTags.Blocks.DIAMOND_CHESTS, IronChestObjectHolders.CRYSTAL_CHEST, "ironchest")), "diamond_to_crystal", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<TagKey<Block>>(Collections.singleton(ModTags.Blocks.OBSIDIAN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.NETHERITE_BARREL)))), "obsidian_to_netherite", (IForgeRegistry<Item>)registry);
        }

        private static void registerItem(Item item, String name, IForgeRegistry<Item> registry) {
            registry.register((IForgeRegistryEntry)((Item)item.setRegistryName(name)));
        }

        @SubscribeEvent
        public static void registerContainers(RegistryEvent.Register<MenuType<?>> event) {
            event.getRegistry().register((IForgeRegistryEntry)((MenuType)new MenuType(MetalBarrelContainer::copper).setRegistryName("copper_container")));
            event.getRegistry().register((IForgeRegistryEntry)((MenuType)new MenuType(MetalBarrelContainer::iron).setRegistryName("iron_container")));
            event.getRegistry().register((IForgeRegistryEntry)((MenuType)new MenuType(MetalBarrelContainer::silver).setRegistryName("silver_container")));
            event.getRegistry().register((IForgeRegistryEntry)((MenuType)new MenuType(MetalBarrelContainer::gold).setRegistryName("gold_container")));
            event.getRegistry().register((IForgeRegistryEntry)((MenuType)new MenuType(MetalBarrelContainer::diamond).setRegistryName("diamond_container")));
            event.getRegistry().register((IForgeRegistryEntry)((MenuType)new MenuType(MetalBarrelContainer::netherite).setRegistryName("netherite_container")));
        }

        @SubscribeEvent
        public static void registerTiles(RegistryEvent.Register<BlockEntityType<?>> event) {
            event.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)new MetalBarrelBlockEntityType<BlockEntity>(MetalBarrelBlockEntityType.copper(), Sets.newHashSet((Object[])new Block[]{ObjectHolders.COPPER_BARREL}), null, 9, 5, (PropertyDispatch.TriFunction<Integer, Inventory, ContainerLevelAccess, AbstractContainerMenu>)((PropertyDispatch.TriFunction)MetalBarrelContainer::copperS)).setRegistryName("copper_tile")));
            event.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)new MetalBarrelBlockEntityType<BlockEntity>(MetalBarrelBlockEntityType.iron(), Sets.newHashSet((Object[])new Block[]{ObjectHolders.IRON_BARREL}), null, 9, 6, (PropertyDispatch.TriFunction<Integer, Inventory, ContainerLevelAccess, AbstractContainerMenu>)((PropertyDispatch.TriFunction)MetalBarrelContainer::ironS)).setRegistryName("iron_tile")));
            event.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)new MetalBarrelBlockEntityType<BlockEntity>(MetalBarrelBlockEntityType.silver(), Sets.newHashSet((Object[])new Block[]{ObjectHolders.SILVER_BARREL}), null, 9, 8, (PropertyDispatch.TriFunction<Integer, Inventory, ContainerLevelAccess, AbstractContainerMenu>)((PropertyDispatch.TriFunction)MetalBarrelContainer::silverS)).setRegistryName("silver_tile")));
            event.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)new MetalBarrelBlockEntityType<BlockEntity>(MetalBarrelBlockEntityType.gold(), Sets.newHashSet((Object[])new Block[]{ObjectHolders.GOLD_BARREL}), null, 9, 9, (PropertyDispatch.TriFunction<Integer, Inventory, ContainerLevelAccess, AbstractContainerMenu>)((PropertyDispatch.TriFunction)MetalBarrelContainer::goldS)).setRegistryName("gold_tile")));
            event.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)new MetalBarrelBlockEntityType<BlockEntity>(MetalBarrelBlockEntityType.diamond(), Sets.newHashSet((Object[])new Block[]{ObjectHolders.DIAMOND_BARREL, ObjectHolders.OBSIDIAN_BARREL}), null, 12, 9, (PropertyDispatch.TriFunction<Integer, Inventory, ContainerLevelAccess, AbstractContainerMenu>)((PropertyDispatch.TriFunction)MetalBarrelContainer::diamondS)).setRegistryName("diamond_tile")));
            event.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)new MetalBarrelBlockEntityType<BlockEntity>(MetalBarrelBlockEntityType.netherite(), Sets.newHashSet((Object[])new Block[]{ObjectHolders.NETHERITE_BARREL}), null, 15, 9, (PropertyDispatch.TriFunction<Integer, Inventory, ContainerLevelAccess, AbstractContainerMenu>)((PropertyDispatch.TriFunction)MetalBarrelContainer::netheriteS)).setRegistryName("netherite_tile")));
            event.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)new MetalBarrelBlockEntityType<BlockEntity>(MetalBarrelBlockEntityType.diamond(), Sets.newHashSet((Object[])new Block[]{ObjectHolders.CRYSTAL_BARREL}), null, 12, 9, (PropertyDispatch.TriFunction<Integer, Inventory, ContainerLevelAccess, AbstractContainerMenu>)((PropertyDispatch.TriFunction)MetalBarrelContainer::diamondS)).setRegistryName("crystal_tile")));
        }
    }
}

